package com.bycom.versapro.Activities;

import static com.bycom.versapro.Config.API_URL;
import static com.bycom.versapro.Config.introPages;
import static com.bycom.versapro.Config.MENU_ICON_PLACEHOLDER;
import static com.bycom.versapro.Serializables.Constant.adMobHelper;
import static com.bycom.versapro.Serializables.Constant.appConfig;
import static com.bycom.versapro.Serializables.Constant.gson;
import static com.bycom.versapro.Utils.AppUtil.EdgeToEdgeEnable;
import static com.bycom.versapro.Utils.NetworkUtil.fetchAppInfo;
import static com.bycom.versapro.Utils.PrefUtil.getAppConfig;
import static com.bycom.versapro.Utils.AppUtil.adjustColorBrightness;
import static com.bycom.versapro.Utils.AppUtil.isColorDark;
import static com.bycom.versapro.MenuTypes.WordPress.UserInterface.WPPostFragment.TYPE_POSTS_BY_BOOKMARK;
import static com.bycom.versapro.MenuTypes.WordPress.UserInterface.WPPostFragment.TYPE_WORDPRESS_HOME;
import static com.bycom.versapro.Utils.PrefUtil.isIntroCompleted;
import static com.bycom.versapro.Utils.PrefUtil.setIntroCompleted;

import android.animation.ArgbEvaluator;
import android.animation.ValueAnimator;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Picture;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PictureDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.splashscreen.SplashScreen;
import androidx.core.view.GravityCompat;
import androidx.core.widget.ImageViewCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.bycom.versapro.MenuTypes.WebView.WebViewFragment;
import com.bycom.versapro.R;
import com.bycom.versapro.MenuTypes.RSS.UserInterface.RSSFeedDetailsFragment;
import com.bycom.versapro.MenuTypes.RSS.UserInterface.RSSFeedFragment;
import com.bycom.versapro.Serializables.AppConfig;
import com.bycom.versapro.Serializables.AppConfig.AppMenu;
import com.bycom.versapro.Serializables.Constant;
import com.bycom.versapro.Serializables.Constant.MenuType;
import com.bycom.versapro.Utils.AdMobHelper;
import com.bycom.versapro.Utils.PrefUtil;
import com.bycom.versapro.Utils.CustomProgressBar;
import com.bycom.versapro.MenuTypes.WordPress.UserInterface.WPPostDetailsFragment;
import com.bycom.versapro.MenuTypes.WordPress.UserInterface.WPPostFragment;
import com.bycom.versapro.MenuTypes.WordPress.UserInterface.WPSearchActivity;
import com.bycom.versapro.Utils.VersaProApp;
import com.caverock.androidsvg.SVG;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.navigation.NavigationView;
import com.google.gson.JsonObject;
import com.onesignal.OneSignal;
import com.squareup.picasso.Picasso;
import com.wordpress.restapi.RESTAPI;

import org.json.JSONObject;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MainActivity extends AppCompatActivity{



    DrawerLayout drawerLayout;
    NavigationView navView;

    ImageView iv_drawer,iv_dayNight,iv_drawer_image;

    public TextView tv_toolbar_title,tv_drawer_title;

    SplashScreen splashScreen;

    public RelativeLayout toolbar;


    ValueAnimator colorAnimator;

    public RelativeLayout rl_main;

    int currentToolbarColor;

    public CustomProgressBar customProgressBar;

    private long backPressedTime = 0;

    private View rl_progress;


    private LinearLayout ll_toolbar_items;






    private final ActivityResultLauncher<Intent> launcher = registerForActivityResult(
            new ActivityResultContracts.StartActivityForResult(),
            result -> {
                if (result.getResultCode() == RESULT_OK) {
                    Intent intent = new Intent(MainActivity.this,MainActivity.class);
                    startActivity(intent);
                    finish();


                }
            }
    );



    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if(!isIntroCompleted()){
            if(!introPages.isEmpty()) {
                startActivity(new Intent(this, IntroActivity.class));
                finish();
                return;
            }else setIntroCompleted(true);
        }


        splashScreen = SplashScreen.installSplashScreen(this);
        setContentView(R.layout.activity_main);
        EdgeToEdgeEnable(this,findViewById(R.id.rl_activity_main));



        currentToolbarColor = getResources().getColor(R.color.background_color,null);
        

        initializeViews();
        initializeActions();


        fetchData();

    }

    private void fetchData(){
        RESTAPI.initialize(this,API_URL);
        fetchAppInfo(new Constant.AppInfoCallback() {
            @Override
            public void onSuccess(AppConfig result) {
                PrefUtil.updateAppInfo(result);
                appConfig = getAppConfig();
                runOnUiThread(() -> processAppInfo());
            }
            @Override
            public void onError(String errorMessage) {
                String message = "An error occurred while trying to connect to the server. Please check your internet connection and try again.";
                try {
                    JSONObject jsonObject = new JSONObject(errorMessage);
                    if(jsonObject.has("message")) message = jsonObject.getString("message");
                }catch (Exception ignored){}

                String finalMessage = message;
                runOnUiThread(() -> new MaterialAlertDialogBuilder(MainActivity.this)
                        .setTitle("Server Error")
                        .setMessage(finalMessage)
                        .setCancelable(false)
                        .setPositiveButton("Retry", (dialog, which) -> fetchData())
                        .setNegativeButton("Exit", (dialog, which) -> {
                            dialog.dismiss();
                            finish();
                        })
                        .show());
            }
        });
    }



    private void initializeViews(){

        rl_main = findViewById(R.id.main);
        rl_progress = findViewById(R.id.rl_progress);
        drawerLayout = findViewById(R.id.drawer_layout);
        navView = findViewById(R.id.nav_view);

        View headerView = navView.getHeaderView(0);
        iv_drawer_image = headerView.findViewById(R.id.iv_drawer_image);
        tv_drawer_title = headerView.findViewById(R.id.tv_drawer_title);

        toolbar = findViewById(R.id.toolbar);
        iv_drawer = toolbar.findViewById(R.id.iv_toolbar_left);
        iv_dayNight = toolbar.findViewById(R.id.iv_toolbar_right);
        tv_toolbar_title = toolbar.findViewById(R.id.tv_toolbar_title);
        ll_toolbar_items = toolbar.findViewById(R.id.ll_toolbar_items);

        customProgressBar = toolbar.findViewById(R.id.customProgressBarView);



    }

    private void initializeActions(){



        navView.setNavigationItemSelectedListener(item -> onMenuSelected(item.getItemId()));

        iv_dayNight.setOnClickListener(v -> {


            Intent intent = new Intent(MainActivity.this,SettingsActivity.class);
            launcher.launch(intent);


        });


        iv_drawer.setOnClickListener(v -> drawerLayout.openDrawer(GravityCompat.START));

        drawerLayout.addDrawerListener(new DrawerLayout.SimpleDrawerListener() {

            @Override
            public void onDrawerOpened(View drawerView) {
                super.onDrawerOpened(drawerView);

                if(PrefUtil.isNight())
                    getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_VISIBLE);
                else getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);


            }


            @Override
            public void onDrawerClosed(View drawerView) {
                super.onDrawerClosed(drawerView);

                if(isColorDark(currentToolbarColor))
                    getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_VISIBLE);
                else getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);


            }


        });



        drawerLayout.addDrawerListener(new DrawerLayout.SimpleDrawerListener() {
            @Override
            public void onDrawerOpened(View drawerView) {
                super.onDrawerOpened(drawerView);
            }
        });




    }


    private void processAppInfo(){


        rl_progress.animate()
                .alpha(0f)
                .setDuration(300)
                .withEndAction(() -> rl_progress.setVisibility(View.GONE));


        initOneSignal();

        adMobHelper = new AdMobHelper(this);

        if(appConfig.app_settings.DefaultDrawerExpand()) new Handler().postDelayed(() -> drawerLayout.openDrawer(GravityCompat.START),1000);
        navView.setBackgroundColor(adjustColorBrightness(appConfig.app_settings.accent_color,10));

        for (int i = 0; i< appConfig.app_menu.size(); i++) {
            AppMenu appMenu = appConfig.app_menu.get(i);
            if (appMenu.isEnabled()) addMenu(i,appMenu);
        }






        // Selecting first item as default
        navView.getMenu().getItem(0).setChecked(true);
        onMenuSelected(0);



        iv_drawer_image.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
            @Override
            public void onGlobalLayout() {
                iv_drawer_image.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                Picasso.get().load(appConfig.app_settings.app_icon)
                        .resize(iv_drawer_image.getWidth(),iv_drawer_image.getHeight())
                        .centerCrop()
                        .into(iv_drawer_image);
            }
        });


        tv_drawer_title.setText(appConfig.app_settings.appname);




    }


    public void addToolbarMenu(int res_id, Runnable runnable) {

        ImageView imageView = new ImageView(this);

        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(
                dpToPx(50),
                dpToPx(50)
        );
        imageView.setLayoutParams(layoutParams);

        ImageViewCompat.setImageTintList(
                imageView,
                ColorStateList.valueOf(ContextCompat.getColor(this, R.color.toolbar_content))
        );

        int padding = dpToPx(15);
        imageView.setPadding(padding, padding, padding, padding);



        imageView.setImageResource(res_id);



        imageView.setOnClickListener(v -> {
            if (runnable != null) {
                runnable.run();
            }
        });


        ll_toolbar_items.addView(imageView);
    }

    public void clearToolbarMenu(){
        ll_toolbar_items.removeAllViews();
    }



    private int dpToPx(int dp) {
        return (int) (dp * getResources().getDisplayMetrics().density);
    }



    private boolean onMenuSelected(int id){
        String menu_type = appConfig.app_menu.get(id).menu_type;
        AppMenu menu = appConfig.app_menu.get(id);

        customProgressBar.setVisibility(View.GONE);


        if(menu_type.equalsIgnoreCase(MenuType.WebView)) {
            tv_toolbar_title.setText(menu.menu_name);
            handleWebView(menu);
        }
        else if(menu_type.equalsIgnoreCase(MenuType.Intent)){
            handleIntent(menu);
            return false;
        }else if(menu_type.equalsIgnoreCase(MenuType.Wordpress)){
            tv_toolbar_title.setText(menu.menu_name);
            handleWordPress(menu);
        }else if(menu_type.equalsIgnoreCase(MenuType.RSS)){
            tv_toolbar_title.setText(menu.menu_name);
            handleRSS(menu);
        }
        else {
            Toast.makeText(this, R.string.not_supported, Toast.LENGTH_SHORT).show();
            return false;
        }
        drawerLayout.closeDrawers();
        return true;
    }

    private void handleIntent(AppMenu appMenu) {



        Uri uri = Uri.parse(appMenu.menu_data);

        try {
            Intent intent = Intent.parseUri(uri.toString(), Intent.URI_INTENT_SCHEME);
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            startActivity(intent);
        } catch (Exception e) {
            try {
                String fragment = uri.getFragment();
                Pattern pattern = Pattern.compile("S\\.browser_fallback_url=([^;]+)");
                Matcher matcher = pattern.matcher(fragment);
                String browserFallbackUrl = matcher.group(1);
                Intent intent = new Intent(Intent.ACTION_VIEW);
                intent.setData(Uri.parse(browserFallbackUrl));
                startActivity(intent);
            }catch (Exception e2) {Toast.makeText(this, R.string.intent_error_message, Toast.LENGTH_SHORT).show();}

        }




    }





    public void changeToolbarBackground(int color,boolean animate){

        if(currentToolbarColor != color) {
            if(animate) {
                colorAnimator = ValueAnimator.ofObject(new ArgbEvaluator(), currentToolbarColor, color);
                colorAnimator.setDuration(300);
                colorAnimator.addUpdateListener(animator -> {
                    int animatedValue = (int) animator.getAnimatedValue();
                    rl_main.setBackgroundColor(animatedValue);
                });

                colorAnimator.start();

            }else {
                if(colorAnimator!=null && colorAnimator.isRunning()) colorAnimator.cancel();
                rl_main.setBackgroundColor(color);
            }

            currentToolbarColor = color;

            if (isColorDark(color)) {
                tv_toolbar_title.setTextColor(Color.WHITE);
                iv_drawer.setColorFilter(Color.WHITE);
                iv_dayNight.setColorFilter(Color.WHITE);
                getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_VISIBLE);
                customProgressBar.setForegroundColor(Color.WHITE);
            } else {
                tv_toolbar_title.setTextColor(Color.BLACK);
                iv_drawer.setColorFilter(Color.BLACK);
                iv_dayNight.setColorFilter(Color.BLACK);
                getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
                customProgressBar.setForegroundColor(Color.BLACK);
            }

        }

    }








    private void initOneSignal(){
        OneSignal.initWithContext(this,appConfig.app_settings.onesignal_app_id);
        //OneSignal.getNotifications().requestPermission(false, Continue.none());
    }

    private void addMenu(int id, AppMenu appMenu){
        Drawable iconDrawable = getDrawable(appMenu.menu_icon);
        if(iconDrawable==null) iconDrawable = getDrawable(MENU_ICON_PLACEHOLDER);
        MenuItem menuItem = navView.getMenu().add(Menu.NONE, id, Menu.NONE, appMenu.menu_name);
        menuItem.setCheckable(true);
        menuItem.setIcon(iconDrawable);

    }


    private Drawable getDrawable(String menu_icon){
        menu_icon = menu_icon.replaceAll("height=\"[^\"]*\"", "");
        menu_icon = menu_icon.replaceAll("width=\"[^\"]*\"", "");
        try {
            SVG svg = SVG.getFromString(menu_icon);
            Picture picture = svg.renderToPicture();
            PictureDrawable pictureDrawable = new PictureDrawable(picture);
            Bitmap bitmap = Bitmap.createBitmap(pictureDrawable.getIntrinsicWidth(), pictureDrawable.getIntrinsicHeight(), Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            pictureDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            pictureDrawable.draw(canvas);
            return new BitmapDrawable(getResources(), bitmap);
        } catch (Exception ignored) {return null;}
    }


    private void handleWebView(AppMenu appMenu){
        getSupportFragmentManager().popBackStack(null, FragmentManager.POP_BACK_STACK_INCLUSIVE); // clear fragment backstack

        Bundle bundle = new Bundle();
        bundle.putSerializable("appMenu",appMenu);
        WebViewFragment webViewFragment = new WebViewFragment();
        webViewFragment.setArguments(bundle);
        FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
        transaction.replace(R.id.container, webViewFragment);
        transaction.commit();

        clearToolbarMenu();

    }

    private void handleRSS(AppMenu appMenu){
        changeToolbarBackground(ContextCompat.getColor(this,R.color.background_color),false);
        getSupportFragmentManager().popBackStack(null, FragmentManager.POP_BACK_STACK_INCLUSIVE);
        RSSFeedFragment rssFeedFragment = new RSSFeedFragment();
        Bundle bundle = new Bundle();
        bundle.putString("BASE_URL",appMenu.menu_data);
        rssFeedFragment.setArguments(bundle);
        FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
        transaction.replace(R.id.container, rssFeedFragment);
        transaction.commit();

        clearToolbarMenu();

    }

    private void handleWordPress(AppMenu appMenu){


        changeToolbarBackground(ContextCompat.getColor(this,R.color.background_color),false);



        getSupportFragmentManager().popBackStack(null, FragmentManager.POP_BACK_STACK_INCLUSIVE); // clear fragment backstack



        WPPostFragment wordPressFragment = new WPPostFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("TYPE",TYPE_WORDPRESS_HOME);
        bundle.putString("BASE_URL",appMenu.menu_data);
        wordPressFragment.setArguments(bundle);
        FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
        transaction.replace(R.id.container, wordPressFragment);
        transaction.commit();



        clearToolbarMenu();

        addToolbarMenu(R.drawable.ic_search, () -> {
            Intent intent = new Intent(MainActivity.this, WPSearchActivity.class);
            intent.putExtra("BASE_URL",appMenu.menu_data);
            startActivity(intent);
        });

        addToolbarMenu(R.drawable.ic_bookmark, () -> {

            Fragment currentFragment = getCurrentFragment();
            if(currentFragment instanceof WPPostFragment fragment) {

                if (fragment.TYPE != TYPE_POSTS_BY_BOOKMARK) {

                    loadBookmarkedPost(appMenu);

                }

            }else loadBookmarkedPost(appMenu);


        });








    }

    private void loadBookmarkedPost(AppMenu appMenu){


        WPPostFragment wordPressFragment = new WPPostFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("TYPE",TYPE_POSTS_BY_BOOKMARK);
        bundle.putString("BASE_URL",appMenu.menu_data);
        wordPressFragment.setArguments(bundle);
        FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
        transaction.hide(getCurrentFragment());
        transaction.add(R.id.container, wordPressFragment);
        transaction.addToBackStack(null);
        transaction.commit();

    }





    private Fragment getCurrentFragment(){
        List<Fragment> fragments = getSupportFragmentManager().getFragments();
        Fragment currentFragment = null;

        for (Fragment fragment : fragments) {
            if (fragment != null && fragment.isVisible()) {
                currentFragment = fragment;
            }

        }

        return currentFragment;
    }




    @Override
    public void onBackPressed(){


        Fragment fragment = getSupportFragmentManager().findFragmentById(R.id.container);

        if(drawerLayout.isDrawerOpen(navView)){
            drawerLayout.closeDrawer(navView);
        }else if(fragment instanceof WebViewFragment)
            ((WebViewFragment)fragment).handleBackPress();
        else if(fragment instanceof WPPostDetailsFragment)
            ((WPPostDetailsFragment)fragment).handleBackPress();
        else if(fragment instanceof WPPostFragment)
            ((WPPostFragment)fragment).handleBackPress();
        else if(fragment instanceof RSSFeedDetailsFragment rssFeedDetailsFragment)
            rssFeedDetailsFragment.handleBackPress();
        else if(fragment instanceof RSSFeedFragment)
            closeActivity();
        else super.onBackPressed();
    }




    public void closeActivity(){
        if (backPressedTime + 2000 > System.currentTimeMillis()) {
            finish();
        } else {
            Toast.makeText(MainActivity.this, R.string.exit_confirm_message, Toast.LENGTH_SHORT).show();
            backPressedTime = System.currentTimeMillis();
        }
    }




}